package treeNAlgo;

import treeN.*;
import java.util.*;

/**
 * InsertNAlgo  -  inserts the supplied parameter (key) into a TreeN
 *  preserving balance with a maximum number of elements per node.
 * @dependency treeNAlgo.ILambda instantiates
 */
public class InsertNAlgo<E> implements ITreeNAlgo<E, TreeN<E>, E> {
  
  /**
   * Splits host upwards if its state &gt; order and splices it into
   * its parent.    The supplied param is an ISpliceCmd used to do the
   * splicing.
   * @SBGen Variable (helper,,,128)
   */
  private SplitUpAndApply<E> splitUpAndSplice;
  
  
  private Comparator<E> comp = new Comparator<E>() {
    public int compare(E o1, E o2) {
      return ((Comparable<E>)o1).compareTo(o2);
    }
  };
  
  /**
   *
   * @param order -- the max possible number of elements in a node
   */
  public InsertNAlgo(int order) {
    System.out.println("InsertNAlgo instantiated.  order = "+order);
    splitUpAndSplice = new SplitUpAndApply<E>(order);
  }
  
  
  public TreeN<E> caseAt(Integer s, final TreeN<E> host, final E... key) {
    switch(s) {
      case 0: {
        return host.spliceAt(0, new TreeN<E>(key[0]));
      }
      
      default: {
        host.execute(new ITreeNAlgo<E,TreeN<E>,ILambda<TreeN<E>,TreeN<E>>>() {
          public TreeN<E> caseAt(Integer s_help, final TreeN<E> h, final ILambda<TreeN<E>,TreeN<E>>... cmd) {
            switch(s_help) {
              case 0: {//empty case: instantiate new tree and splice into parent
                /**
                 * At this point the host is an empty subtree of some parent
                 * tree. Because the parent tree is balanced, it must be a
                 * leaf!
                 */
                return cmd[0].apply(new TreeN<E>(key[0]));
              }
              
              
              default: {
                final int[] x={0};  // trick to get past restrictions on final
                // x[0] is the index of insertion location.
                for(; x[0] < s_help; x[0]++) {// find insertion location
                  E d = h.getDat(x[0]);
                  if(0 < comp.compare(d, key[0])) {
                    if (d.equals(key[0]))
                      return h; // no duplicate keys allowed
                    else break;
                  }
                }
                h.getChild(x[0]).execute(this, new ILambda<TreeN<E>,TreeN<E>>() {
                  /**
                   * @param child a TreeN subtree of h.
                   */
                  public TreeN<E> apply(TreeN<E>... child){
                    // splice child tree into parent
                    return h.spliceAt(x[0],child[0]);
                  }
                }
                );
                // split up host if necessary
                return h.execute(splitUpAndSplice, cmd);
              }
            }
          }
        } , new ILambda<TreeN<E>, TreeN<E>>() {// say something meaningful here
          /**
           * @param child not used.
           */
          public TreeN<E> apply(TreeN<E>... child){
            return host;  //no-op for this one
          }
        });
        return host;
      }
    }
  }
}
